import numpy as np
import pickle
import pandas as pd

batch_size_list = [1,  10, 100, 1000  ]
r_list = [0.25, 0.5, 1, 2, 4, 8]
DF = pd.DataFrame(columns=["Errors", "Batch Size", "r"])

for r in r_list:
    with open('record_r'+str(r)+'.pickle', 'rb') as handle:
        record1 = pickle.load(handle)

    for batch_size in batch_size_list:
        d = {}
        num_obs =len(record1[batch_size])//3
        d["Errors"] = [np.mean(h[-num_obs:]) for h in record1[batch_size]]
        d["Batch Size"] = [batch_size]*len(d["Errors"])
        d["r"] = [r]*len(d["Errors"])

        D = pd.DataFrame(d)
        DF = pd.concat([DF, D])

print("DataFrame Constructed.")

import seaborn as sns
import matplotlib.pyplot as plt
# plt.ylim(0, 0.01)

sns.set(style="ticks", palette="pastel")
bp = sns.boxplot(x="r", y="Errors", data=DF, hue="Batch Size", palette=["red", "blue", "yellow", "green"],
                 showfliers=False, showmeans=True)
fig = bp.get_figure()
fig.show()
# fig.savefig("fig2.png", dpi=300)